function [b]=udpputconv(data,type)
ld=max(size(data)); 
data=double(data);   
switch(type)
case 0 % uint8
b=bitand(data,(2^8)-1);
case 1 % sint8
idx =find(data<0); data(idx) = data(idx)+2^8; 
b=bitand(data,(2^8)-1);
case 2 % uint16le
b(1:2:(2*ld))=bitand(data,(2^8)-1); 
b(2:2:(2*ld))=bitand(floor(data/(2^8)),(2^8)-1); 
case 3 % sint16le   
idx =find(data<0); data(idx) = data(idx)+2^16; 
b(1:2:(2*ld))=bitand(data,(2^8)-1); 
b(2:2:(2*ld))=bitand(floor(data/(2^8)),(2^8)-1); 
case 4 % uint32le
b(1:4:(4*ld))=bitand(data,(2^8)-1); 
b(2:4:(4*ld))=bitand(floor(data/(2^8)),(2^8)-1); 
b(3:4:(4*ld))=bitand(floor(data/(2^16)),(2^8)-1); 
b(4:4:(4*ld))=bitand(floor(data/(2^24)),(2^8)-1); 
case 5 % sint32le   
idx =find(data<0); data(idx) = data(idx)+2^32; 
b(1:4:(4*ld))=bitand(data,(2^8)-1); 
b(2:4:(4*ld))=bitand(floor(data/(2^8)),(2^8)-1); 
b(3:4:(4*ld))=bitand(floor(data/(2^16)),(2^8)-1); 
b(4:4:(4*ld))=bitand(floor(data/(2^24)),(2^8)-1); 
case 6 % float32le
data=float2uint(data);
b(1:4:(4*ld))=bitand(data,(2^8)-1); 
b(2:4:(4*ld))=bitand(floor(data/(2^8)),(2^8)-1); 
b(3:4:(4*ld))=bitand(floor(data/(2^16)),(2^8)-1); 
b(4:4:(4*ld))=bitand(floor(data/(2^24)),(2^8)-1); 
case 10 % string
b=data;
otherwise 
end
endfunction

function [f]=float2uint(p_data)
%p_data=single(p_data);
%Ian Stothers
sb=(p_data<0);
p_data=abs(p_data);
eb=-127*ones(size(p_data));
idx=find(p_data>=(2.^eb));
eb(idx)=floor(log2(p_data(idx)));
d=((p_data).*(2.^(-(eb))));
eb=(eb+127);
f=bitand(floor((d*2^23)+0.5),(2^23)-1)+floor(eb*2^23)+floor(sb*2^31);
endfunction

